package furny.swing.admin.tags;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.List;

import furny.entities.Tag;

/**
 * Transferable for tags. (for drag and drop)
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class TagTransferable implements Transferable {
  private final List<Tag> list;

  /**
   * Instantiates a new tag transferable.
   * 
   * @param list
   *          the list
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public TagTransferable(final List<Tag> list) {
    this.list = list;
  }

  @Override
  public Object getTransferData(final DataFlavor flavor)
      throws UnsupportedFlavorException {

    if (!isDataFlavorSupported(flavor)) {
      throw new UnsupportedFlavorException(flavor);
    }
    return list;
  }

  @Override
  public DataFlavor[] getTransferDataFlavors() {
    return new DataFlavor[] { new TagFlavor() };
  }

  @Override
  public boolean isDataFlavorSupported(final DataFlavor flavor) {
    for (final DataFlavor f : getTransferDataFlavors()) {
      if (f.equals(flavor)) {
        return true;
      }
    }
    return false;
  }
}
